---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：29-Worker Log（ワーカーログ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **JavaScript関数の動作詳細**：utils.jsの直接読み込みは行っていないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/worker/ui/LogPage.scala`（183行）
- E-02: `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerWebUI.scala`（58行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは3種類（エグゼキュータ/ドライバー/ワーカー自身） | E-01 (48-57行目, 74-83行目: パターンマッチ) | ○ |
| C-02 | ページ名はlogPage | E-01 (32行目: `WebUIPage("logPage")`) | ○ |
| C-03 | サポートlogTypeはstderr, stdout, out | E-01 (35行目: `supportedLogTypes = Set("stderr", "stdout", "out")`) | ○ |
| C-04 | デフォルトバイト数は100KB | E-01 (36行目: `defaultBytes = 100 * 1024`) | ○ |
| C-05 | エグゼキュータログディレクトリはworkDir/appId/executorId/ | E-01 (49-50行目, 75-76行目) | ○ |
| C-06 | ドライバーログディレクトリはworkDir/driverId/ | E-01 (51-52行目, 77-78行目) | ○ |
| C-07 | ワーカー自身のログディレクトリはSPARK_LOG_DIR | E-01 (53-54行目, 79-80行目) | ○ |
| C-08 | パストラバーサル防止チェック | E-01 (142-144行目: `Utils.isInDirectory(workDir, normalizedLogDir)`) | ○ |
| C-09 | RollingFileAppender対応 | E-01 (156行目: `RollingFileAppender.getSortedRolledOverFiles`) | ○ |
| C-10 | "out"タイプは.out拡張子ファイルを検索 | E-01 (150-153行目) | ○ |
| C-11 | offset未指定時は末尾からbyteLength分 | E-01 (161行目: `val offset = offsetOption.getOrElse(totalLength - byteLength)`) | ○ |
| C-12 | renderLogメソッドでテキストAPI提供 | E-01 (38-62行目), E-02 (49-51行目) | ○ |
| C-13 | テキストAPIにバイト範囲ヘッダ付き | E-01 (60行目: `s"==== Bytes $startByte-$endByte of $logLength of $logDir$logType ===="`) | ○ |
| C-14 | Back to Masterリンク（activeMasterWebUiUrl） | E-01 (86行目: `<a href={worker.activeMasterWebUiUrl}>Back to Master</a>`) | ○ |
| C-15 | initLogPage JavaScript初期化 | E-01 (109-110行目) | ○ |
| C-16 | ログ表示領域はheight:80vh | E-01 (117行目) | ○ |
| C-17 | ページタイトルは "{logType} log page for {pageName}" | E-01 (126行目) | ○ |
| C-18 | loadMore/loadNew JavaScript関数の動作詳細 | **根拠なし**（utils.jsの直接読み込み未実施） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: loadMore/loadNewのAJAX呼び出し先・動作詳細はutils.jsの確認が必要
  - 候補：core/src/main/resources/org/apache/spark/ui/static/utils.js

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドの処理は全て根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パストラバーサル防止のisInDirectoryの動作が正確か確認
- [ ] "out"タイプのファイル検索ロジックが正確か確認
- [ ] utils.jsのloadMore/loadNew関数の動作が設計書の記述と一致するか確認
- [ ] 不正なパラメータ組み合わせ時のエラー処理が正確か確認
